# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .filter_operation_eq import FilterOperationEq
from .filter_operation_gt import FilterOperationGt
from .filter_operation_gte import FilterOperationGte
from .filter_operation_includes_item import FilterOperationIncludesItem
from .filter_operation_lt import FilterOperationLt
from .filter_operation_lte import FilterOperationLte

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class FilterOperation(pydantic.BaseModel):
    """
    API request model for a filter comparison operation.
    """

    eq: typing.Optional[FilterOperationEq]
    gt: typing.Optional[FilterOperationGt]
    gte: typing.Optional[FilterOperationGte]
    lt: typing.Optional[FilterOperationLt]
    lte: typing.Optional[FilterOperationLte]
    includes: typing.Optional[typing.List[typing.Optional[FilterOperationIncludesItem]]]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
