# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .configurable_data_source_names import ConfigurableDataSourceNames
from .data_source_create_component import DataSourceCreateComponent
from .data_source_create_custom_metadata_value import DataSourceCreateCustomMetadataValue

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class DataSourceCreate(pydantic.BaseModel):
    """
    Schema for creating a data source.
    """

    name: str = pydantic.Field(description="The name of the data source.")
    source_type: ConfigurableDataSourceNames
    custom_metadata: typing.Optional[typing.Dict[str, typing.Optional[DataSourceCreateCustomMetadataValue]]]
    component: DataSourceCreateComponent = pydantic.Field(description="Component that implements the data source")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
