# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .pg_vector_hnsw_settings import PgVectorHnswSettings

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CloudPostgresVectorStore(pydantic.BaseModel):
    supports_nested_metadata_filters: typing.Optional[bool]
    database: str
    host: str
    password: str
    port: int
    user: str
    table_name: str
    schema_name: str
    embed_dim: int
    hybrid_search: typing.Optional[bool]
    perform_setup: typing.Optional[bool]
    hnsw_settings: typing.Optional[PgVectorHnswSettings]
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
