# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .llm_parameters import LlmParameters
from .preset_composite_retrieval_params import PresetCompositeRetrievalParams

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ChatApp(pydantic.BaseModel):
    """
    Schema for a chat app
    """

    id: str = pydantic.Field(description="Unique identifier")
    created_at: typing.Optional[dt.datetime]
    updated_at: typing.Optional[dt.datetime]
    name: str = pydantic.Field(description="Name of the chat app")
    retriever_id: str = pydantic.Field(description="ID of the retriever to use for the chat app")
    llm_config: LlmParameters = pydantic.Field(description="Configuration for the LLM model to use for the chat app")
    retrieval_config: PresetCompositeRetrievalParams = pydantic.Field(
        description="Configuration for the retrieval model to use for the chat app"
    )
    project_id: str = pydantic.Field(description="ID of the project the chat app belongs to")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
